; ROM dump was made by Conventional Memories 2024-02-01 13:51
; Disassembled by JDat on 2024-02-01 19:12
; Disassmbeld with custom version of 8039dasm.c tweaked for 8741A
; Diassembler downloaded from https://github.com/daveho/asm48
; 8039dasm.c roots come from MAME project (see asm48 github repo for more information)


; Some questions while disassembling
; 
; What is RAM 0x08 ? stack manipulation in ext IRQ
; What is RAM 0x09 ? stack manipulation in ext IRQ

; What is RAM 0x20 ?
; What is RAM 0x23 ?

; PORT 2 Pin 3 - Interrupt pin, goes to 80130 IRQ 4

; What is RAM 0x27 ? Data for sendig to CPU?
; What is RAM 0x28 ? Data for BUS status register if BUS is ready (CPU can read this)
; What is RAM 0x29 ? Data for BUS status register if BUS is busy (CPU can read this)


; What is RAM 0x38 ?
; What is RAM 0x39 ?

; BANK 0 registers
; R0 used as pointer to RAM
; R1 used as pointer to RAM
; R2
; R3
; R4
; R5 keyboard scan code???
; R6
; R7

; BANK 1 registers
; R0 used as pointer to RAM
; R1 used as pointer to RAM
; R2 timer overflow counter (when zero, do more) set to 2 when zero
; R3 used as saved data for A (kinda push AX and POP AX on x86)
; R4
; R5 used by timer interrupt and main loop
; R6 used by timer interrupt
; R7 used by timer interrupt

        _000_vect_reset:
PC:000	jmp  _068_boot_entry    ; reset vector
PC:002	db 0FFh                 ; not programmed
        _003_vect_ext_irq:
PC:003	jmp  _0A0_sub_ext_irq   ; external interrupt vector
PC:005	db 0FFh                 ; not programmed
PC:006	db 0FFh                 ; not programmed
;=======================================================================
        _007_vect_timer_irq_and_sub:    ; timer interrupt
PC:007	stop tcnt               ; stop timer
PC:008	sel  rb1                ; switch to bank 1
PC:009	mov  r3,a               ; save accumulator to R3 register
PC:00A	jobf  .label_010        ; jump if bus output register have data (CPU not read it yet)
PC:00C	anl  p2, 0F7h           ; clear bit 3 on port 2 (IRQ pin for CPU)
PC:00E	call _2CA_sub_send_data_to_CPU
        .label_010:
PC:010	mov  a, 0ADh            ; move 0ADh value to accumulator
PC:012	mov  t,a                ; update timer with new value 0ADh
PC:013	jtf  .label_015         ; wait for timer data register to update???
        .label_015:
PC:015	strt t                  ; start timer
PC:016	mov  a,r7               ; read accumulator from R7
PC:017	cpl  a                  ; invert accumulator
PC:018	jb2  .label_028         ; jump if accumulator bit 2 is set
PC:01A	djnz r6, .label_028     ; decrement R6 and jump if not zero
PC:01C	mov  r0, 020h           ; R0 = 0x20
PC:01E	mov  a,@r0              ; read RAM byte 0x20
PC:01F	mov  r6,a               ; move RAM byte 0x20 to R6
PC:020	mov  r0, 029h           ; R0 = 0x29
PC:022	mov  a,@r0              ; read RAM byte 0x29
PC:023	mov  r5,a               ; move RAM byte 0x29 to R5
PC:024	mov  a, 0FFh            ; move accumulator 0xFF
PC:026	call _2A7_sub
        .label_028:
PC:028	djnz r2, .irq_exit_030  ; decrement R2 and jump forward if not zero
PC:02A	mov  r2, 002h           ; R2 = 0x2
PC:02C	mov  a,r7               ; get R7 value
PC:02D	orl  a, 080h            ; set bit7 in accumulator
PC:02F	mov  r7,a               ; store noew byte in R7
        .irq_exit_030:
PC:030	mov  a,r3               ; restore accumulator from R3
PC:031	retr                    ; return from timer interrupt
;=======================================================================
        _032_sub_main_loop:     ; Main loop
                                ; jump from 09E (entry boot)
PC:032	en   i                  ; enable external interrupt
PC:033	sel  rb1                ; switch to bank 1
PC:034	dis  i                  ; disable external interrupt???
PC:035	mov  a,r7               ; read R7 BANK 1
PC:036	cpl  a                  ; invert accumulator
PC:037	jb7  _032_sub_main_loop ; wait for bit 7 set to 0 in R7 BANK1 (repeat loop)
PC:039	cpl  a                  ; make accumulator equal to R7 again
PC:03A	anl  a, 07Fh            ; clear bit 7
PC:03C	mov  r7,a               ; return data to R7 BANK 1
PC:03D	en   i                  ; enable external interrupt
PC:03E	cpl  a                  ; invert accumulator (R7)
PC:03F	jb1  .label_052         ; jump if bit 1 in R7 zero
PC:041	mov  r1, 039h           ; R1 = 0x39h
PC:043	mov  a,@r1              ; read RAM byte 0x39
PC:044	dec  a                  ; decrement accumulator
PC:045	mov  @r1,a              ; put back to RAM byte 0x39
PC:046	jz   .label_04A         ; jump if RAM byte 0x39 = 0
PC:048	jmp  .label_052         ; jump if RAM byte 0x39 more than zero (not zero)
        .label_04A:
PC:04A	anl  p2, 0EFh           ; set pin 4 in port 2 low
PC:04C	mov  r5, 000h           ; clear register R5 BANK 1
PC:04E	mov  a, 0FDh            ; accumulator - 0xFD
PC:050	call _2A7_sub           ; send 0xFD to CPU???
        .label_052:
PC:052	sel  rb1                ; switch to BANK 1 (just in case _2A7_sub messed with banks)
PC:053	mov  a,r7               ; read R7 BANK 1
PC:054	cpl  a                  ; invert accumulator
PC:055	sel  rb0                ; switch to BANK 0
PC:056	jb0 _032_sub_main_loop  ; if bit 0 in R7 BANK 1 zero, repeat loop
PC:058	call _11A_sub
PC:05A	call _0DB_sub
PC:05C	mov  a, 003h            ; accumulator = 0x3
PC:05E	cpl  a                  ; invert accumulator 0x3 => 0xFC
PC:05F	inc  a                  ; increment accumulator = 0xFD
PC:060	add  a,r5               ; accumulator = R5 BANK 0 + accumulator
PC:061	cpl  c                  ; invert carry flag
PC:062	jnc _032_sub_main_loop  ; repear loop if carry flag is clear
PC:064	call _146_sub
PC:066	jmp _032_sub_main_loop  ;return to beginning main loop
;=======================================================================
        _068_boot_entry:        ; cold boot
PC:068	anl  p2, 07Fh           ; clear PORT2 pin 7 (not found on schematics)
PC:06A	anl  p2, 0B7h           ; clear PORT2 pin 3 (IRQ) and pin 6 (NMI)
PC:06C	sel  rb1                ; switch to bank 1
PC:06D	mov  r7, 000h           ; clear R7 bank1
PC:06F	mov  r2, 002h           ; bank 1 R2 = 0x02
PC:071	mov  r6, 001h           ; bank 1 R6 = 0x01
PC:073	sel  rb0                ; switch to bank 0
PC:074	mov  r0, 020h           ; bank 0 R0 = 0x20
PC:076	mov  @r0, 001h          ; set RAM 0x20 = 0x01
PC:078	inc  r0                 ; increment R0 = 0x21
PC:079	mov  @r0, 00Fh          ; set RAM 0x21 = 0x0F
PC:07B	inc  r0                 ; increment R0 = 0x22
PC:07C	mov  @r0, 002h          ; set RAM 0x22 = 0x02
PC:07E	inc  r0                 ; increment R0 = 0x23
PC:07F	mov  @r0, 032h          ; set RAM 0x23 = 0x32
PC:081	mov  r0, 039h           ; bank 0 R0 = 0x39
PC:083	mov  @r0, 032h          ; set RAM 0x39 = 0x32
PC:085	mov  r0, 027h           ; bank 0 R0 = 0x27
PC:087	mov  a, 000h            ; clear accumulator
PC:089	mov  @r0,a              ; clear RAM 0x27 = 0x00
PC:08A	inc  r0                 ; increment R0 = 0x28
PC:08B	mov  @r0,a              ; clear RAM 0x28 = 0x00
PC:08C	inc  r0                 ; increment R0 = 0x29
PC:08D	mov  @r0,a              ; clear RAM 0x29 = 0x00
PC:08E	mov  r4,014h            ; bank 0 R4 = 0x14 (counter 0x14 times)
PC:090	mov  r0,02Bh            ; bank 0 R0 = 0x2B
        .label_092:
PC:092	mov  @r0, 000h          ; clear RAM 0x2B = 0
PC:094	djnz r4, .label_092     ; repeat 0x14 times
PC:096	mov  a, 0ADh            ; move 0xAD value to accumulator
PC:098	mov  t,a                ; update timer with new value 0xAD
PC:099	orl  p2, 080h           ; set PORT2 pin 7
PC:09B	strt t                  ; start timer
PC:09C	en   i                  ; enable external interrupt
PC:09D	en   tcnti              ; enabel timer interrupt
PC:09E	jmp  _032_sub_main_loop ; end cold boot jump to main loop
;=======================================================================
        _0A0_sub_ext_irq:       ; external interrupt
PC:0A0	sel  rb1                ; switch to bank 1
PC:0A1	mov  r3,a               ; save accumulator to R3
PC:0A2	mov  r1, 038h           ; R1 = 0x38
PC:0A4	mov  a,@r1              ; Read RAM 0x38
PC:0A5	mov  r1,a               ; R1 = RAM 0x38
PC:0A6	jf1 .label_0B2          ; jump if CPU BUS flag F1 true, was accessed with A0 active (command)
PC:0A8	in   a,DBB              ; read data from CPU
PC:0A9	mov  @r1,a              ; RAM 0x38 = data from CPU
        .label_0AA:
PC:0AA	mov  r1, 023h           ; R1 = 0x23
PC:0AC	mov  a,@r1              ; read RAM 0x23
PC:0AD	mov  r1, 039h           ; R1 = 0x39
PC:0AF	mov  @r1,a              ; RAM 0x39 = RAM 0x23
PC:0B0	mov  a,r3               ; restore accumulator from R3
PC:0B1	retr                    ; return from interrupt
        .label_0B2:
PC:0B2	in   a,DBB              ; read command from CPU
PC:0B3	jnz .label_0C3          ; jump if CPU data not zero
PC:0B5	mov  a, 06Ah            ; accumulator = 0x6A
PC:0B7	mov  r0, 008h           ; R0 = 0x08
PC:0B9	mov  @r0,a              ; write to RAM 0x008 = 0x6A
PC:0BA	mov  a, 000h            ; clear accumulator
PC:0BC	inc  r0                 ; increment R0 = 0x09
PC:0BD	mov  @r0,a              ; clear RAM 0x09
PC:0BE	mov  a, 001h            ; accumulator = 0x01
PC:0C0	mov  psw,a              ; change ProgStatusWord stack pointer to stack frame 1
PC:0C1	dis  i                  ; disable external interrupt
PC:0C2	retr                    ; return from inteerupt
        .label_0C3:
PC:0C3	jb7 .label_0D0          ; jump if bit 7 in CPU command set
PC:0C5	mov  r7,a               ; R7 = command from CPU
PC:0C6	anl  a, 010h            ; get bit 4 of CPU command
PC:0C8	mov  r1,a               ; save bit 4 of CPU command
PC:0C9	in   a,p2               ; read PORT 2
PC:0CA	anl  a, 0EFh            ; clear bit 4 of PORT 2 (goes to PAL)
PC:0CC	orl  a,r1               ; PORT2 bit 4 OR CPU command bit 4
PC:0CD	outl p2,a               ; return bit 4 to PORT 2
PC:0CE	jmp  .label_0AA         ; jump
        .label_0D0:
PC:0D0	jb6 .label_0AA          ; jump if bit 6 in CPU command set
PC:0D2	mov  r1, 038h           ; R1 = 0x38
PC:0D4	anl  a, 003h            ; CPU command AND bits 0, 1
PC:0D6	add a, 020h             ; add CPU bits 0,1 with 0x20
PC:0D8	mov  @r1,a              ; RAM 0x38 = CPU command bits after adding
PC:0D9	jmp .label_0AA          ; jump
;=======================================================================
        _0DB_sub:               ; call from
                                ; 005a (main loop)
                                ; read keyboard matrix
PC:0DB	mov  r1,024h            ; R1 = 0x24
PC:0DD	mov  r5, 000h           ; R5 = 0x0
PC:0DF	mov  r4, 008h           ; R4 = 0x8
        .label_0E1:
PC:0E1	mov  r3, 008h           ; R3 = 0x8
PC:0E3	mov  a,r4               ; accumulator = R4
PC:0E4	anl  a, 007h            ; accumulator = b0000 0111
PC:0E6	mov  r0,a               ; R0 = 0x7
PC:0E7	in   a,p2               ; read PORT2
PC:0E8	anl  a, 0F8h            ; clear bits 0,1,2 (they are connected to 3-to-8 decoder)
PC:0EA	orl  a,r0               ; set bits 0,1,2 becaue R0=b0000 0111
PC:0EB	outl p2,a               ; write to PROT2
PC:0EC	in   a,p1               ; read PORT1
PC:0ED	clr  c                  ; clear carry flag
PC:0EE	cpl  a                  ; invert accumulator
        .label_0EF:
PC:0EF	jz .label_0F6           ; jump if PORT1 = 0
PC:0F1	rrc  a                  ; rotate right takeing int account carry >> with carry
PC:0F2	jc .label_0FD           ; jump if carry is set (bit0 was set before)
        .label_0F4:
PC:0F4	djnz r3, .label_0EF     ; do it again 8 times. For every bit in accumulator
        .label_0F6:
PC:0F6	djnz r4, .label_0E1     ; do all shiftings again 8 times? Why?
PC:0F8	mov  r0, 037h           ; R0 = 0x37
PC:0FA	mov  a,r5               ; accumulator = R5
PC:0FB	mov  @r0,a              ; RAM[0x37] = R5
PC:0FC	ret                     ; return
        .label_0FD:
PC:0FD	mov  r2,a               ; R2= accumulator
PC:0FE	inc  r5                 ; increment R5; R5 = 0x01
PC:0FF	mov  a, 003h            ; accumulator = 0x3 (b0000 0011)
PC:101	cpl  a                  ; invert acuumulator = 0xFC (b1111 1100)
PC:102	inc  a                  ; increment accumulator = 0xFD (b1111 1101)
PC:103	add  a,r5               ; accumulator + R5
PC:104	cpl  c                  ; invert carry flag
PC:105	jc  .label_109          ; jump forward if carry not set while adding accumulator and R5
PC:107	jmp .label_0F4          ; jumb back (do it again!)
        .label_109:
PC:109	mov  a,r4               ; acuumulator = R4 (what value in R4???)
PC:10A	rl   a                  ; shift left acuumulator
PC:10B	rl   a                  ; acuumulator = accumulator << 3
PC:10C	rl   a
PC:10D	anl  a, 038h            ; accumulator AND 0x38 (b0011 1000) clear/mask sometring)
PC:10F	mov  r0,a               ; store it in R0
PC:110	mov  a,r3               ; accumulator = R3 (value 0x08)
PC:111	anl  a, 007h            ; accumulator and 0x07 (b0000 0111) calear all, but keyboard decoder pins)
PC:113	orl  a,r0               ; acuumulator = (accumulator AND mask 0x38) or (accumulator AND 0x07) bla bla bla
PC:114	mov  @r1,a              ; store this mess into RAM[0x24] 
PC:115	inc  r1                 ; increment R1 (R1=0x25)
PC:116	mov  a,r2               ; acuumulator = R2
PC:117	clr  c                  ; clear carry
PC:118	jmp .label_0F4          ; do it again
;=======================================================================
        _11A_sub:               ; call from 
                                ; 058 (main loop)
PC:11A	mov  a, 000h            ; clrear accumulator
PC:11C	jt1 .label_120          ; if Test1 pin set, skip (no key on this line)
PC:11E	orl  a, 040h            ; set bit 6 in acccumulator
        .label_120:
PC:120	jt0 .label_124          ; if Test0 pin is set, skip (no key on this line)
PC:122	orl  a, 020h            ; set bit 5 in accumulator
PC:124	mov  r0,a               ; store accumulator in R0
        .label_124:
PC:125	in   a,p2               ; read port2
PC:126	anl  a, 0F8h            ; save all pins, but alter pins 0, 1, 2
PC:128	orl  a, 002h            ; set bit 1
PC:12A	outl p2,a               ; return to port 2
PC:12B	in   a,p1               ; read port1 (keyboard lines)
PC:12C	cpl  a                  ; invert port1 (we have external pullups)
PC:12D	anl  a, 001h            ; get pin11 (bit 0) line from keyboard
PC:12F	jz .label_135           ; if clear (buttons not pressed) jump forward
PC:131	mov  a,r0               ; restore test pins to accumulator
PC:132	orl  a, 080h            ; set bit 7 in accumulator
PC:134	mov  r0,a               ; store in R0
        .label_135:
PC:135	mov  r1, 02Ah           ; R1 = 0x2A
PC:137	mov  a,@r1              ; read RAM[0x2A]
PC:138	cpl  a                  ; invert RAM[0x2A]
PC:139	inc  a                  ; increment RAM[0x2A]
PC:13A	add  a,r0               ; add RAM[0x2A] with Test pin state
PC:13B	cpl  c                  ; invert carry
PC:13C	jz .label_141           ; skip if zero
PC:13E	mov  a,r0               ; accumulator = test pins
PC:13F	mov  @r1,a              ; store rest pins in RAM[0x2A]
PC:140	ret                     ; return
        .label_141:
PC:141	mov  a,r0               ; accumulator = test pins
PC:142	mov  r1, 029h           ; R1 = 0x29
PC:144	mov  @r1,a              ; store test pins in RAM[0x29]
PC:145	ret                     ; return
;=======================================================================
        _146_sub:               ; call from 
                                ; 064 (main loop)
PC:146	mov  r0, 02Ch
PC:148	mov  r4, 004h
        .label_14A:
PC:14A	mov  a, 0EFh
PC:14C	anl  a,@r0
PC:14D	mov  @r0,a
PC:14E	inc  r0
PC:14F	inc  r0
PC:150	inc  r0
PC:151	djnz r4, .label_14A
PC:153	mov  r1, 037h
PC:155	mov  a,@r1
PC:156	jz   .label_175
PC:158	mov  r7,a
PC:159	mov  r1, 024h
        .label_15B:
PC:15B	mov  a,@r1
PC:15C	mov  r2,a
PC:15D	mov  r4, 004h
PC:15F	mov  r0, 02Ch
        .label_161:
PC:161	mov  a,@r0
PC:162	jz   .label_16D
PC:164	dec  r0
PC:165	mov  a,@r0
PC:166	cpl  a
PC:167	inc  a
PC:168	add  a,r2
PC:169	cpl  c
PC:16A	jz   .label_1EF
PC:16C	inc  r0
        .label_16D:
PC:16D	inc  r0
PC:16E	inc  r0
PC:16F	inc  r0
PC:170	djnz r4, .label_161
        .label_172:
PC:172	inc  r1
PC:173	djnz r7, .label_15B
        .label_175:
PC:175	mov  r0, 02Ch
PC:177	mov  r4, 004h
        .label_179
PC:179	mov  a,@r0
PC:17A	jz   .label_17F
PC:17C	cpl  a
PC:17D	jb4  .label_1D3
        .label_17F
PC:17F	inc  r0
        .label_180:
PC:180	inc  r0
PC:181	inc  r0
PC:182	djnz r4, .label_179
PC:184	mov  r1, 037h
PC:186	mov  a,@r1
PC:187	mov  r1, 024h
PC:189	jz   .label_193
PC:18B	mov  r7,a
        .label_18C:
PC:18C	mov  a,@r1
PC:18D	inc  a
PC:18E	jnz  .label_194
        .label_190:
PC:190	inc  r1
PC:191	djnz r7, .label_18C
        .label_193:
PC:193	ret
        .label_194:
PC:194	mov  a,@r1
PC:195	xrl  a, 010h
PC:197	jz   .label_190
PC:199	mov  r0, 02Ch
        .label_19B:
PC:19B	mov  a,@r0
PC:19C	jz   .label_1A3
PC:19E	inc  r0
PC:19F	inc  r0
PC:1A0	inc  r0
PC:1A1	jmp  .label_19B
        .label_1A3:
PC:1A3	dec  r0
PC:1A4	mov  a,@r1
PC:1A5	mov  @r0,a
PC:1A6	inc  r0
PC:1A7	mov  a,r1
PC:1A8	mov  r2,a
PC:1A9	mov  r1, 029h
PC:1AB	mov  a,@r1
PC:1AC	anl  a, 0E0h
PC:1AE	orl  a, 008h
PC:1B0	mov  @r0,a
PC:1B1	inc  r0
PC:1B2	mov  @r0, 001h
PC:1B4	mov  r6, 004h
PC:1B6	mov  r0, 02Ch
        .label_1B8:
PC:1B8	mov  a,@r0
PC:1B9	jz   .label_1CA
PC:1BB	jb3  .label_1CA
PC:1BD	jb0  .label_1CA
PC:1BF	anl  a, 0F0h
PC:1C1	orl  a, 004h
PC:1C3	mov  @r0,a
PC:1C4	inc  r0
PC:1C5	mov  r1, 021h
PC:1C7	mov  a,@r1
PC:1C8	mov  @r0,a
PC:1C9	dec  r0
        .label_1CA:
PC:1CA	inc  r0
PC:1CB	inc  r0
PC:1CC	inc  r0
PC:1CD	djnz r6, .label_1B8
PC:1CF	mov  a,r2
PC:1D0	mov  r1,a
PC:1D1	jmp  .label_190
        .label_1D3:
PC:1D3	cpl  a
PC:1D4	jb0  .label_1E1
PC:1D6	anl  a, 0F0h
PC:1D8	orl  a, 001h
PC:1DA	mov  @r0,a
PC:1DB	inc  r0
PC:1DC	mov  a, 002h
PC:1DE	mov  @r0,a
PC:1DF	jmp  .label_180
        .label_1E1:
PC:1E1	inc  r0
PC:1E2	mov  a,@r0
PC:1E3	dec  a
PC:1E4	jz   .label_1E9
PC:1E6	mov  @r0,a
PC:1E7	jmp  .label_180
        .label_1E9:
PC:1E9	dec  r0
PC:1EA	mov  @r0,a
PC:1EB	anl  p2, 0BFh
PC:1ED	jmp  .label_17F
        .label_1EF:
PC:1EF	inc  r0
PC:1F0	mov  a,@r0
PC:1F1	mov  r3,a
PC:1F2	inc  r0
PC:1F3	mov  a,@r0
PC:1F4	mov  r6,a
PC:1F5	mov  a,r0
PC:1F6	sel  rb1
PC:1F7	mov  r4,a
PC:1F8	sel  rb0
PC:1F9	mov  a,r3
PC:1FA	jmp  .label_200
PC:1FC	db 0FFh
PC:1FD	db 0FFh
PC:1FE	db 0FFh
PC:1FF	db 0FFh
        .label_200:
PC:200	jb3  .label_20F
PC:202	jb2  .label_22B
PC:204	jb1  .label_249
PC:206	anl  a, 0E0h
PC:208	orl  a, 008h
PC:20A	mov  r3,a
PC:20B	mov  a, 001h
PC:20D	jmp  .label_279
        .label_20F:
PC:20F	mov  a,r6
PC:210	dec  a
PC:211	jz   .label_215
PC:213	jmp  .label_279
        .label_215:
PC:215	mov  a,r2
PC:216	call _28A_sub_translate_scan_code
PC:218	mov  r2,a
PC:219	mov  a,r3
PC:21A	anl  a,0E0h
PC:21C	mov  r5,a
PC:21D	mov  a,r2
PC:21E	call _2A7_sub
PC:220	mov  a,r5
PC:221	anl  a, 0F0h
PC:223	orl  a, 004h
PC:225	mov  r3,a
PC:226	mov  r0, 021h
PC:228	mov  a,@r0
PC:229	jmp  .label_279
        .label_22B:
PC:22B	mov  a,r6
PC:22C	dec  a
PC:22D	jz   .label_231
PC:22F	jmp  .label_279
        .label_231:
PC:231	sel  rb1
PC:232	mov  a,r7
PC:233	sel  rb0                ; switch to bank 0
PC:234	cpl  a
PC:235	jb3  .label_239
PC:237	jmp  .label_23E
        .label_239:
PC:239	mov  r0, 021h
PC:23B	mov  a,@r0
PC:23C	jmp  .label_279
        .label_23E:
PC:23E	mov  a,r3
PC:23F	anl  a, 0F0h
PC:241	orl  a, 002h
PC:243	mov  r3,a
PC:244	mov  r0, 022h
PC:246	mov  a,@r0
PC:247	jmp  .label_279
        .label_249:
PC:249	mov  a,r6
PC:24A	dec  a
PC:24B	jz   .label_24F
PC:24D	jmp  .label_279
        .label_24F:
PC:24F	mov  a,r3
PC:250	anl  a, 0E0h
PC:252	mov  r0, 029h
PC:254	cpl  a
PC:255	inc  a
PC:256	add  a,@r0
PC:257	cpl  c
PC:258	nop
PC:259	nop
PC:25A	nop
PC:25B	nop
PC:25C	jz   .label_269
PC:25E	mov  a,@r0
PC:25F	anl  a, 0E0h
PC:261	orl  a, 004h
PC:263	mov  r3,a
PC:264	mov  r0, 021h
PC:266	mov  a,@r0
PC:267	jmp  .label_279
        .label_269:
PC:269	mov  a,r2
PC:26A	call _28A_sub_translate_scan_code
PC:26C	mov  r2,a
PC:26D	mov  a,r3
PC:26E	anl  a, 0E0h
PC:270	orl  a, 010h
PC:272	mov  r5,a
PC:273	mov  a,r2
PC:274	call _2A7_sub
PC:276	mov  r0, 022h
PC:278	mov  a,@r0
        .label_279:
PC:279	sel  rb1                ; switch to bank 1
PC:27A	xch  a,r4
PC:27B	sel  rb0
PC:27C	mov  r0,a
PC:27D	sel  rb1
PC:27E	mov  a,r4
PC:27F	sel  rb0
PC:280	mov  @r0,a
PC:281	dec  r0
PC:282	mov  a,r3
PC:283	orl  a, 010h
PC:285	mov  @r0,a
PC:286	mov  @r1,0FFh
PC:288	jmp  .label_172
;=======================================================================
        _28A_sub_translate_scan_code:   ;call from
                                ; 216 (sub_146)
                                ; 26a (sub_146)
                                ;
                                ; unknown parameter in accumulator
                                ;
PC:28A	rl   a                  ; accumulator shift left a = a << 1
PC:28B	rl   a                  ; accumulator shift left a = a << 1
PC:28C	anl  a, 0FCh            ; accumulator = accumulator AND 0xFC
PC:28E	mov  r5,a               ; R5 = accumulator
PC:28F	mov  r0,029h            ; R0 = 0x29
PC:291	mov  a,@r0              ; accumulator RAM 0x29
PC:292	rr   a                  ; accumulator shift right a = a >> 1
PC:293	rr   a                  ; accumulator shift right a = a >> 1
PC:294	rr   a                  ; accumulator shift right a = a >> 1
PC:295	rr   a                  ; accumulator shift right a = a >> 1
PC:296	rr   a                  ; accumulator shift right a = a >> 1
PC:297	anl  a, 003h            ; accumulator = accumulator AND 0x03
PC:299	orl  a,r5               ; accumulator = OR R5 (address in lookup table)
PC:29A	movp3 a,@a              ; accumulator = ROM lookup table[a]
PC:29B	mov  r5,a               ; R5 = keyboard code from table
PC:29C	mov  a,@r0              ; accumulator = RAM 0x29
PC:29D	anl  a, 080h            ; accumulator = RAM 0x29 AND 0x80
PC:29F	jz   .label_2A5         ; jump if RAM 0x29 bit 7 is zero
PC:2A1	mov  a,09Fh             ; accumulator = 0x9F
PC:2A3	anl  a,r5               ; accumulator = accumulator and R5 (scan code)
PC:2A4	mov  r5,a               ; R5 = accumulator, stoe new keycode to R5
        .label_2A5:
PC:2A5	mov  a,r5               ; accumulator = R5 (scan code)
PC:2A6	ret                     ; return scan code in accumulator
;=======================================================================
        _2A7_sub:               ; call from 
                                ; 026 (timer irq)
                                ; 050 (main loop)
                                ; 21e (sub_146)
                                ; 274 (sub_146)
                                ; unknown parameter in accumulator
PC:2A7	mov  r0,a               ; save accumulator into R0
PC:2A8	xrl  a, 0FEh            ; xor accumulator with 0xFE
PC:2AA	jnz  .label_2AF         ; do more if bit 0 in accumulator true
PC:2AC	orl  p2, 040h           ; set pin 6 on port 2 (NMI on CPU)
PC:2AE	ret                     ; we are done with NMI
        .label_2AF:
PC:2AF	mov  a,r0               ; restore accumulator
PC:2B0	mov  r0, 028h           ; R0 = 0x28
PC:2B2	jobf .label_2BC         ; jump if BUS output register not read by (CPU)
PC:2B4	anl  p2, 0F7h           ; clear pin 3 on port 2 (interrupt pin)
PC:2B6	outl bus,a              ; send accumulator contents to CPU
PC:2B7	mov  a,r5               ; get R5 to accumulator
PC:2B8	mov  sts,a              ; store R5 in BUS status register
PC:2B9	orl  p2, 008h           ; set pin 3 on port 2 (activate interrupt)
PC:2BB	ret                     ; we are done with sending byte
        .label_2BC:
PC:2BC	xch  a,@r0              ; swap RAM 0x28 with accumulator
PC:2BD	jz   .label_2C3         ; jump if RAM 0x28 was empty
PC:2BF	dec  r0                 ; decrement R0, R0 = 0x27
PC:2C0	mov  @r0, 0FEh          ; Move to RAM 0x27 = 0xFE
PC:2C2	ret                     ; we are done
        .label_2C3:
PC:2C3	xch  a,@r0              ; exchange RAM 0x28 with acuumulator
PC:2C4	dec  r0                 ; decrement R0, R0 = 0x27
PC:2C5	mov  @r0,a              ; move RAM 0x28 to RAM 0x27
PC:2C6	inc  r0                 ; increment R0, R0 = 0x28
PC:2C7	mov  a,r5               ; accumulator = R5
PC:2C8	mov  @r0,a              ; store in RAM 0x28 R5 contents
PC:2C9	ret                     ; we are done
;=======================================================================
        _2CA_sub_send_data_to_CPU:      ; call from
                                ; 00e (timer irq)
PC:2CA	mov  r0,028h            ; R0 = 0x28
PC:2CC	mov  a,@r0              ; read RAM byte 0x28
PC:2CD	jz   .label_2DA         ; jump if RAM byte 0x28 = 0
PC:2CF	dec  r0                 ; decrement R0 (R0=0x27)
PC:2D0	mov  a,@r0              ; read RAM byte 0x27
PC:2D1	outl DDB,a              ; sent to BUS (To CPU) OBF Flag is set now
PC:2D2	inc  r0                 ; increment R0 (R0=0x28)
PC:2D3	mov  a,@r0              ; read RAM byte 0x28
PC:2D4	mov  @r0,000h           ; set RAM  byte 0x28 to 0x00
PC:2D6	mov  sts,a              ; set BUS status from old RAM 0x28 via A. Only bits 4-7 affected
PC:2D7	orl  p2,008h            ; set bit 3 on port 2
PC:2D9	ret                     ; return
        .label_2DA:
PC:2DA	mov  r0, 029h           ; R0 = 0x29
PC:2DC	mov  a,@r0              ; read RAM byte 0x29
PC:2DD	mov  sts,a              ; set BUS status from RAM 0x29 via A. Only bits 4-7 affected
PC:2DE	ret                     ; return
;=======================================================================

PC:2DF	db 0FFh

PC:2E0	db 0FFh
PC:2E1	db 0FFh
PC:2E2	db 0FFh
PC:2E3	db 0FFh

PC:2E4	db 0FFh
PC:2E5	db 0FFh
PC:2E6	db 0FFh
PC:2E7	db 0FFh

PC:2E8	db 0FFh
PC:2E9	db 0FFh
PC:2EA	db 0FFh
PC:2EB	db 0FFh

PC:2EC	db 0FFh
PC:2ED	db 0FFh
PC:2EE	db 0FFh
PC:2EF	db 0FFh

PC:2F0	db 0FFh
PC:2F1	db 0FFh
PC:2F2	db 0FFh
PC:2F3	db 0FFh

PC:2F4	db 0FFh
PC:2F5	db 0FFh
PC:2F6	db 0FFh
PC:2F7	db 0FFh

PC:2F8	db 0FFh
PC:2F9	db 0FFh
PC:2FA	db 0FFh
PC:2FB	db 0FFh

PC:2FC	db 0FFh
PC:2FD	db 0FFh
PC:2FE	db 0FFh
PC:2FF	db 0FFh
        _300_key_table:
PC:300	db 009h         ; TAB
PC:301	db 0C9h         ; shift+TAB
PC:302	db 089h         ; code+TAB
PC:303	db 08Bh         ; code+shift+TAB

PC:304	db 0FFh
PC:305	db 0FFh
PC:306	db 0FFh
PC:307	db 0FFh

PC:308	db 0FFh
PC:309	db 0FFh
PC:30A	db 0FFh
PC:30B	db 0FFh

PC:30C	db 0FFh
PC:30D	db 0FFh
PC:30E	db 0FFh
PC:30F	db 0FFh

PC:310	db 0FFh
PC:311	db 0FFh
PC:312	db 0FFh
PC:313	db 0FFh

PC:314	db 0FFh
PC:315	db 0FFh
PC:316	db 0FFh
PC:317	db 0FFh

PC:318	db 0FFh
PC:319	db 0FFh
PC:31A	db 0FFh
PC:31B	db 0FFh

PC:31C	db 01Bh         ; ESC
PC:31D	db 01Bh         ; shift+ESC
PC:31E	db 09Bh         ; code+ESC
PC:31F	db 0FEh         ; code+shift+ESC        ;not verified

PC:320	db 031h         ; 1
PC:321	db 021h         ; shift+1
PC:322	db 0B1h         ; code+1
PC:323	db 0A1h         ; code+shift+1

PC:324	db 039h         ; 9
PC:325	db 028h         ; shift+9
PC:326	db 0B9h         ; code+9
PC:327	db 0A8h         ; code+shift+9

PC:328	db 069h         ; I
PC:329	db 049h         ; shift+I
PC:32A	db 0E9h         ; code+I
PC:32B	db 0E9h         ; code+shift+I

PC:32C	db 02Dh         ; -
PC:32D	db 05Fh         ; shift+-
PC:32E	db 0ADh         ; code+-
PC:32F	db 07Fh         ; code+shift+-

PC:330	db 0C6h         ; LEFT
PC:331	db 0D0h         ; shift+LEFT
PC:332	db 0D4h         ; code+LEFT
PC:333	db 0D8h         ; code+shift+LEFT

PC:334	db 027h         ; '
PC:335	db 022h         ; shift+'
PC:336	db 060h         ; code+'
PC:337	db 05Ch         ; code+shift+'

PC:338	db 00Dh         ; RETURN
PC:339	db 0CDh         ; shift+RETURN
PC:33A	db 08Dh         ; code+RETURN
PC:33B	db 08Ch         ; code+shift+RETURN

PC:33C	db 02Fh         ; /
PC:33D	db 03Fh         ; shift+/
PC:33E	db 0BFh         ; code+/
PC:33F	db 0BFh         ; code+shift+/

PC:340	db 0FFh
PC:341	db 0FFh
PC:342	db 0FFh
PC:343	db 0FFh

PC:344	db 038h         ; 8
PC:345	db 02Ah         ; shift+8
PC:346	db 0B8h         ; code+8
PC:347	db 0AAh         ; code+shift+8

PC:348	db 075h         ; U
PC:349	db 055h         ; shift+U
PC:34A	db 0F5h         ; code+U
PC:34B	db 0F5h         ; code+shift+U

PC:34C	db 070h         ; P
PC:34D	db 050h         ; shift+P
PC:34E	db 0F0h         ; code+P
PC:34F	db 0F0h         ; code+shift+P

PC:350	db 03Bh         ; ;
PC:351	db 03Ah         ; shift+;
PC:352	db 07Eh         ; code+;
PC:353	db 07Ch         ; code+shift+;

PC:354	db 02Ch         ; ,
PC:355	db 03Ch         ; shift+,
PC:356	db 05Bh         ; code+,
PC:357	db 07Bh         ; code+shift+,

PC:358	db 02Eh         ; .
PC:359	db 03Eh         ; shift+.
PC:35A	db 05Dh         ; code+.
PC:35B	db 07Dh         ; code+shift+.

PC:35C	db 06Dh         ; M
PC:35D	db 04Dh         ; shift+M
PC:35E	db 0EDh         ; code+M
PC:35F	db 0EDh         ; code+shift+M

PC:360	db 0FFh
PC:361	db 0FFh
PC:362	db 0FFh
PC:363	db 0FFh

PC:364	db 037h         ; 7
PC:365	db 026h         ; shift+7
PC:365	db 0B7h         ; code+7
PC:367	db 0A6h         ; code+shift+7

PC:368	db 079h         ; Y
PC:369	db 059h         ; shift+Y
PC:36A	db 0F9h         ; code+Y
PC:36B	db 0F9h         ; code+shift+Y

PC:36C	db 06Bh         ; K
PC:36D	db 04Bh         ; shift+K
PC:36E	db 0EBh         ; code+K
PC:36F	db 0EBh         ; code+shift+K

PC:370	db 06Ch         ; L
PC:371	db 04Ch         ; shift+L
PC:372	db 0ECh         ; code+L
PC:373	db 0ECh         ; code+shift+L

PC:374	db 062h         ; B
PC:375	db 042h         ; shift+B
PC:376	db 0E2h         ; code+B
PC:377	db 0E2h         ; code+shift+B

PC:378	db 06Eh         ; N
PC:379	db 04Eh         ; shift+N
PC:37A	db 0EEh         ; code+N
PC:37B	db 0EEh         ; code+shift+N

PC:37C	db 076h         ; V
PC:37D	db 056h         ; shift+V
PC:37E	db 0F6h         ; code+V
PC:37F	db 0F6h         ; code+shift+V

PC:380	db 0FFh
PC:381	db 0FFh
PC:382	db 0FFh
PC:383	db 0FFh

PC:384	db 036h         ; 6
PC:385	db 05Eh         ; shift+6
PC:386	db 0B6h         ; code+6
PC:387	db 0DEh         ; code+shift+6

PC:388	db 074h         ; T
PC:389	db 054h         ; shift+T
PC:38A	db 0F4h         ; code+T
PC:38B	db 0F4h         ; code+shift+T

PC:38C	db 068h         ; H
PC:38D	db 048h         ; shift+H
PC:38E	db 0E8h         ; code+H
PC:38F	db 0E8h         ; code+shift+H

PC:390	db 06Ah         ; J
PC:391	db 04Ah         ; shift+J
PC:392	db 0EAh         ; code+J
PC:393	db 0EAh         ; code+shift+J

PC:394	db 078h         ; X
PC:395	db 058h         ; shift+X
PC:396	db 0F8h         ; code+X
PC:397	db 0F8h         ; code+shift+X

PC:398	db 063h         ; C
PC:399	db 043h         ; shift+C
PC:39A	db 0E3h         ; code+C
PC:39B	db 0E3h         ; code+shift+C

PC:39C	db 071h         ; Q
PC:39D	db 051h         ; shift+Q
PC:39E	db 0F1h         ; code+Q
PC:39F	db 0F1h         ; code+shift+Q

PC:3A0	db 0FFh
PC:3A1	db 0FFh
PC:3A2	db 0FFh
PC:3A3	db 0FFh

PC:3A4	db 035h         ; 5
PC:3A5	db 025h         ; shift+5
PC:3A6	db 0B5h         ; code+5
PC:3A7	db 0A5h         ; code+shift+5

PC:3A8	db 072h         ; R
PC:3A9	db 052h         ; shift+R
PC:3AA	db 0F2h         ; code+R
PC:3AB	db 0F2h         ; code+shift+R

PC:3AC	db 066h         ; F
PC:3AD	db 046h         ; shift+F
PC:3AE	db 0E6h         ; code+F
PC:3AF	db 0E6h         ; code+shift+F

PC:3B0	db 067h         ; G
PC:3B1	db 047h         ; shift+G
PC:3B2	db 0E7h         ; code+G
PC:3B3	db 0E7h         ; code+shift+G

PC:3B4	db 073h         ; S
PC:3B5	db 053h         ; shift+S
PC:3B6	db 0F3h         ; code+S
PC:3B7	db 0F3h         ; code+shift+S

PC:3B8	db 061h         ; A
PC:3B9	db 041h         ; shift+A
PC:3BA	db 0E1h         ; code+A
PC:3BB	db 0E1h         ; code+shift+A

PC:3BC	db 07Ah         ; Z
PC:3BD	db 05Ah         ; shift+Z
PC:3BE	db 0FAh         ; code+Z
PC:3BF	db 0FAh         ; code+shift+Z

PC:3C0	db 0FFh
PC:3C1	db 0FFh
PC:3C2	db 0FFh
PC:3C3	db 0FFh

PC:3C4	db 034h         ; 4
PC:3C5	db 024h         ; shift+4
PC:3C6	db 0B4h         ; code+4
PC:3C7	db 0A4h         ; code+shift+4

PC:3C8	db 033h         ; 3
PC:3C9	db 023h         ; shift+3
PC:3CA	db 0B3h         ; code+3
PC:3CB	db 0A3h         ; code+shift+3

PC:3CC	db 065h         ; E
PC:3CD	db 045h         ; shift+E
PC:3CE	db 0E5h         ; code+E
PC:3CF	db 0E5h         ; code+shift+E

PC:3D0	db 064h         ; D
PC:3D1	db 044h         ; shift+D
PC:3D2	db 0E4h         ; code+D
PC:3D3	db 0E4h         ; code+shift+D

PC:3D4	db 077h         ; W
PC:3D5	db 057h         ; shift+W
PC:3D6	db 0F7h         ; code+W
PC:3D7	db 0F7h         ; code+shift+W

PC:3D8	db 032h         ; 2
PC:3D9	db 040h         ; shift+2
PC:3DA	db 0B2h         ; code+2
PC:3DB	db 0C0h         ; code+shift+2

PC:3DC	db 0FFh
PC:3DD	db 0FFh
PC:3DE	db 0FFh
PC:3DF	db 0FFh

PC:3E0	db 020h         ; SPACE
PC:3E1	db 020h         ; shift+SPACE
PC:3E2	db 020h         ; code+SPACE
PC:3E3	db 020h         ; code+shift+SPACE

PC:3E4	db 030h         ; 0
PC:3E5	db 029h         ; shift+0
PC:3E6	db 0B0h         ; code+0
PC:3E7	db 0A9h         ; code+shift+0

PC:3E8	db 06Fh         ; O
PC:3E9	db 04Fh         ; shift+O
PC:3EA	db 0EFh         ; code+O
PC:3EB	db 0EFh         ; code+shift+O

PC:3EC	db 03Dh         ; =
PC:3ED	db 02Bh         ; shift+=
PC:3EE	db 0BDh         ; code+=
PC:3EF	db 0ABh         ; code+shift+=

PC:3F0	db 0C5h         ; UP
PC:3F1	db 0CFh         ; shift+UP
PC:3F2	db 0D3h         ; code+UP
PC:3F3	db 0D7h         ; code+shift+UP

PC:3F4	db 0C7h         ; RIGHT
PC:3F5	db 0D1h         ; shift+RIGHT
PC:3F6	db 0D5h         ; code+RIGHT
PC:3F7	db 0D9h         ; code+shift+RIGHT

PC:3F8	db 0C4h         ; DOWN
PC:3F9	db 0CEh         ; shift+DOWN
PC:3FA	db 0D2h         ; code+DOWN
PC:3FB	db 0D6h         ; code+shift+DOWN

PC:3FC	db 008h         ; BACKSPACE
PC:3FD	db 0C8h         ; shift+BACKSPACE
PC:3FE	db 088h         ; code+BACKSPACE
PC:3FF	db 08Ah         ; code+shift+BACKSPACE
